;Quest'opera e' stata rilasciata sotto la licenza Creative Commons
;Attribuzione-Non commerciale-Condividi allo stesso modo 2.5 Italia.
;
;Per leggere una copia della licenza visita il sito web
;http://creativecommons.org/licenses/by-nc-sa/2.5/it/ o spedisci una
;lettera a Creative Commons, 171 Second Street, Suite 300,
;San Francisco, California, 94105, USA.
;
;
;This work is licensed under the Creative Commons
;Attribution-Noncommercial-Share Alike 2.5 Italy License.
;
;To view a copy of this license, visit
;http://creativecommons.org/licenses/by-nc-sa/2.5/it/ or send a letter
;to Creative Commons, 171 Second Street, Suite 300, San Francisco,
;California, 94105, USA.

; ________________________________________________
; |      Controllo display LCD per 877 demo      |
; |______________________________________________|
; |   Src File                                   |
; |______________________________________________|
; |   Tipo      : ASM                            |
; |   Versione  : 1                              |
; |   Release   : 0                              |
; |   Autore    : Lain Walter                    |
; |   Data      : 02/11/09                       |
; |______________________________________________|


;_______________________________________________________Inizializza display
;Routine di inizializzazione dei display
;Registri modificati:
;       Sistema
;       b_DATA
;       b_ADDRESS
;       R0H
;       R0L
;       R1H
Disp_Init:
        BSF c_PRL_PORT,c_PRL_PIN            ;Setta retroill. on
        BCF c_DDS_PORT,c_DDS_PIN            ;Setta function set
        BCF c_DRW_PORT,c_DRW_PIN            ;

        CLRF R0H                            ;loop attesa on >15 ms
        CLRF R0L
        CLRF R1H
        MOVLF 0x04,R1H                      ;
;___loop3 = (loop2 + 5)*4 + 2 = 78082 (15,6164 ms)
D_INI03 MOVLF 0x13,R0H                      ;2
;___loop2 = (loop1 + 5)*19 + 2 = 19515 (3,903 ms)
D_INI02 MOVLF 0xFF,R0L                      ;2
;___loop1 = 4*255 + 2 = 1022 (204,4 us)
D_INI01 NOP                                 ;1
        DECFSZ R0L,f                        ;1(2)
        GOTO D_INI01                        ;2
        DECFSZ R0H,f                        ;1(2)
        GOTO D_INI02                        ;2
        DECFSZ R1H,f                        ;1(2)
        GOTO D_INI03                        ;2

        Bus_Data_Out                        ;bus dati in uscita
        MOVLF c_ADDR_DISP,b_ADDRESS
        CALL IO_SETADD
        MOVLF c_DISP_INIT1,c_DATA_PORT      ;Function set (1)
        BCF c_OE_PORT,c_OE_PIN              ;attiva OE indirizzi
        BSF c_OE_PORT,c_OE_PIN              ;disattiva OE indirizzi

        MOVLF 0x19,R0H                      ;Attende 5,1ms
D_INI12 MOVLF 0xFF,R0L                      ; ...
D_INI11 NOP                                 ; ...
        DECFSZ R0L,f                        ; ...
        GOTO D_INI11                        ; ...
        DECFSZ R0H,f                        ; ...
        GOTO D_INI12                        ; ...
        MOVLF c_DISP_INIT1,c_DATA_PORT      ;Function set (2)
        BCF c_OE_PORT,c_OE_PIN              ;attiva OE indirizzi
        BSF c_OE_PORT,c_OE_PIN              ;disattiva OE indirizzi

        MOVLF 0x96,R0L                      ;Attende 120us
D_INI21 NOP                                 ; ...
        DECFSZ R0L,f                        ; ...
        GOTO D_INI21                        ; ...
        MOVLF c_DISP_INIT1,c_DATA_PORT      ;Function set (3)
        BCF c_OE_PORT,c_OE_PIN              ;attiva OE indirizzi
        BSF c_OE_PORT,c_OE_PIN              ;disattiva OE indirizzi

        MOVLF 0x96,R0L                      ;Attende 120us
D_INI31 NOP                                 ; ...
        DECFSZ R0L,f                        ; ...
        GOTO D_INI31                        ; ...
        Bus_Data_In                         ;bus dati in ingresso
        MOVLF c_DISP_INIT2,b_DATA           ;Setta bit interf., numero righe e dim. font
        CALL Disp_WrCmd
        MOVLF c_DISP_OFFCMD,b_DATA          ;Spegne tutto
        CALL Disp_WrCmd
        MOVLF c_DISP_CLRCMD,b_DATA          ;Clear display
        CALL Disp_WrCmd
        MOVLF c_DISP_MODCMD,b_DATA          ;Setta entry mode
        CALL Disp_WrCmd
        MOVLF c_DISP_ONCMD,b_DATA           ;Accende Display
        CALL Disp_WrCmd
        BSF c_PRL_PORT,c_PRL_PIN            ;attiva retroilluminazione

        CLRF R0H
        CLRF R0L
        CLRF R1H
        RETURN

;_______________________________________________________Invio comando display
;Routine di invio comandi display
;Dati in ingresso:
;       b_DATA = comando
;Registri modificati:
;       Sistema
;       b_DATA
;       b_ADDRESS
Disp_WrCmd:
        CALL Disp_WaitBF                    ;Attende LCD libero
        BCF c_DDS_PORT,c_DDS_PIN            ;Setta scrittura comando
        BCF c_DRW_PORT,c_DRW_PIN            ;
        Bus_Data_Out                        ;bus dati in uscita
        MOVLF c_ADDR_DISP,b_ADDRESS
        CALL IO_SETADD
        BCF c_OE_PORT,c_OE_PIN              ;attiva OE indirizzi
        MOVFF b_DATA,c_DATA_PORT            ;scrive comando
        BSF c_OE_PORT,c_OE_PIN              ;disattiva OE indirizzi
        NOP
        BSF c_DDS_PORT,c_DDS_PIN            ;Setta LCD in lettura
        BSF c_DRW_PORT,c_DRW_PIN            ;
        Bus_Data_In                         ;bus dati in ingresso
        RETURN

;_______________________________________________________Invio dato display
;Routine di invio dati display
;Dati in ingresso:
;       b_DATA = dato
;Registri modificati:
;       Sistema
;       b_DATA
;       b_ADDRESS
Disp_WrData:
        CALL Disp_WaitBF                    ;Attende LCD libero
        BSF c_DDS_PORT,c_DDS_PIN            ;Setta scrittura dato
        BCF c_DRW_PORT,c_DRW_PIN            ;
        MOVLF c_ADDR_DISP,b_ADDRESS
        CALL IO_SETADD
        Bus_Data_Out                        ;bus dati in uscita
        BCF c_OE_PORT,c_OE_PIN              ;attiva OE indirizzi
        MOVFF b_DATA,c_DATA_PORT            ;scrive dato
        BSF c_OE_PORT,c_OE_PIN              ;disattiva OE indirizzi
        NOP
        BSF c_DDS_PORT,c_DDS_PIN            ;Setta LCD in lettura
        BSF c_DRW_PORT,c_DRW_PIN            ;
        Bus_Data_In                         ;bus dati in ingresso
        RETURN

;_______________________________________________________Set indirizzo memoria display
;Routine di selezione dell'indirizzo DDRAM del display
;Dati in ingresso:
;       b_DATA = indirizzo
;Registri modificati:
;       Sistema
;       b_DATA
;       b_ADDRESS
Disp_SetAdd:
        CALL Disp_WaitBF                    ;Attende LCD libero
        BCF c_DDS_PORT,c_DDS_PIN            ;Setta scrittura comando
        BCF c_DRW_PORT,c_DRW_PIN            ;
        Bus_Data_Out                        ;bus dati in uscita
        BSF b_DATA,7                        ;il bit7 deve essere 1
        MOVLF c_ADDR_DISP,b_ADDRESS
        CALL IO_SETADD
        BCF c_OE_PORT,c_OE_PIN              ;attiva OE indirizzi
        MOVFF b_DATA,c_DATA_PORT            ;scrive indirizzo
        BSF c_OE_PORT,c_OE_PIN              ;disattiva OE indirizzi
        NOP
        BSF c_DDS_PORT,c_DDS_PIN            ;Setta LCD in lettura
        BSF c_DRW_PORT,c_DRW_PIN            ;
        Bus_Data_In                         ;bus dati in ingresso
        RETURN

;_______________________________________________________Attesa display libero
;Routine di attesa display libero
;Dati in ingresso:
;
;Registri modificati:
;       Sistema
;       b_DATA
;       b_ADDRESS
Disp_WaitBF:
        Bus_Data_In                         ;bus dati in ingresso
        BCF c_DDS_PORT,c_DDS_PIN            ;Setta lettura busy
        BSF c_DRW_PORT,c_DRW_PIN            ;

D_WBF   BSF c_OE_PORT,c_OE_PIN              ;disattiva OE indirizzi
        CALL Disp_Wait                      ;Piccolo ritardo
        MOVLF c_ADDR_DISP,b_ADDRESS
        CALL IO_SETADD
        BCF c_OE_PORT,c_OE_PIN              ;attiva OE indirizzi
        NOP
        BTFSC c_DATA_PORT,7                 ;E' Busy ?
        GOTO D_WBF                          ;SI: Cicla
        BSF c_OE_PORT,c_OE_PIN              ;disattiva OE indirizzi
        NOP
        BSF c_DDS_PORT,c_DDS_PIN            ;Setta LCD in lettura
        BSF c_DRW_PORT,c_DRW_PIN            ;
        RETURN

;_______________________________________________________Ritardo display
;Routine di ritardo per display
;Dati in ingresso:
;
;Registri modificati:
;       Sistema
;       R0H
Disp_Wait:                                  ;2
        CLRF R0H                            ;1
        NOP                                 ;1
D_WAIT1 INCF R0H,f                          ;loop da 9 istruzioni
        NOP                                 ;
        BTFSS R0H,1                         ;
        GOTO D_WAIT1                        ;
        CLRF R0H                            ;1
        RETURN                              ;2 (=16 istruzioni)

