; ________________________________________________
; |               Generic PIC macros             |
; |______________________________________________|
; |   Src File                                   |
; |______________________________________________|
; |   Type      : INC                            |
; |   Version   : 1                              |
; |   Release   : 3                              |
; |   Author    : Pinton Fabio, mod. Lain Walter |
; |   Date      : 22/10/20                       |
; |______________________________________________|

;        NOLIST
;****************************************************************************
;                                   MACRO
;****************************************************************************

_bpos SET 0x20       ;Present allocation position

;============================================================================
;   Allocation bank selection
;============================================================================
BANK_0  MACRO
_bpos = 0x20
        ENDM

BANK_1  MACRO
_bpos = 0xA0
        ENDM

BANK_2  MACRO
_bpos = 0x120
        ENDM

BANK_3  MACRO
_bpos = 0x1A0
        ENDM

BANK_4  MACRO
_bpos = 0x220
        ENDM

BANK_5  MACRO
_bpos = 0x2A0
        ENDM

BANK_6  MACRO
_bpos = 0x320
        ENDM
	
BANK_7  MACRO
_bpos = 0x3A0
        ENDM

BANK_8  MACRO
_bpos = 0x420
        ENDM

BANK_9  MACRO
_bpos = 0x4A0
        ENDM

BANK_10 MACRO
_bpos = 0x520
        ENDM

BANK_11 MACRO
_bpos = 0x5A0
        ENDM

BANK_12 MACRO
_bpos = 0x620
        ENDM

BANK_13 MACRO
_bpos = 0x6A0
        ENDM

BANK_14 MACRO
_bpos = 0x720
        ENDM
	
BANK_15 MACRO
_bpos = 0x7A0
        ENDM

BANK_16 MACRO
_bpos = 0x820
        ENDM

BANK_17 MACRO
_bpos = 0x8A0
        ENDM

BANK_18 MACRO
_bpos = 0x920
        ENDM

BANK_19 MACRO
_bpos = 0x9A0
        ENDM

BANK_20 MACRO
_bpos = 0xA20
        ENDM

BANK_21 MACRO
_bpos = 0xAA0
        ENDM

BANK_22 MACRO
_bpos = 0xB20
        ENDM
	
BANK_23 MACRO
_bpos = 0xBA0
        ENDM

BANK_24 MACRO
_bpos = 0xC20
        ENDM

BANK_25 MACRO
_bpos = 0xCA0
        ENDM

BANK_26 MACRO
_bpos = 0xD20
        ENDM

BANK_27 MACRO
_bpos = 0xDA0
        ENDM

BANK_28 MACRO
_bpos = 0xE20
        ENDM

BANK_29 MACRO
_bpos = 0xEA0
        ENDM

BANK_30 MACRO
_bpos = 0xF20
        ENDM
	
BANK_31 MACRO
_bpos = 0xFA0
        ENDM

BANK_32 MACRO
_bpos = 0x1020
        ENDM

BANK_33 MACRO
_bpos = 0x10A0
        ENDM

BANK_34 MACRO
_bpos = 0x1120
        ENDM

BANK_35 MACRO
_bpos = 0x11A0
        ENDM

BANK_36 MACRO
_bpos = 0x1220
        ENDM

BANK_37 MACRO
_bpos = 0x12A0
        ENDM

BANK_38 MACRO
_bpos = 0x1320
        ENDM
	
BANK_39 MACRO
_bpos = 0x13A0
        ENDM

BANK_40 MACRO
_bpos = 0x1420
        ENDM

BANK_41 MACRO
_bpos = 0x24A0
        ENDM

BANK_42 MACRO
_bpos = 0x1520
        ENDM

BANK_43 MACRO
_bpos = 0x15A0
        ENDM

BANK_44 MACRO
_bpos = 0x1620
        ENDM

BANK_45 MACRO
_bpos = 0x16A0
        ENDM

BANK_46 MACRO
_bpos = 0x1720
        ENDM
	
BANK_47 MACRO
_bpos = 0x17A0
        ENDM

BANK_48 MACRO
_bpos = 0x1820
        ENDM

BANK_49 MACRO
_bpos = 0x18A0
        ENDM
	
BANK_50 MACRO
_bpos = 0x1920
        ENDM

;============================================================================
;   Variables type definitions
;============================================================================

BYTE    MACRO lab
lab EQU _bpos
_bpos += 1
        ENDM

WORD    MACRO lab
lab EQU _bpos
_bpos += 2
        ENDM

LONG    MACRO lab
lab EQU _bpos
_bpos += 4
        ENDM

;****************************************************************************
;                            GENERIC USE REGISTERS
;****************************************************************************
R0	    equ 0x70			    ; R0
R0H		equ 0x70		    ;
R0L		equ 0x71		    ;

R1	    equ 0x72			    ; R1
R1H		equ 0x72		    ;
R1L		equ 0x73		    ;

R2	    equ 0x74			    ; R2
R2H		equ 0x74		    ;
R2L		equ 0x75		    ;

R3	    equ 0x76			    ; R3
R3H		equ 0x76		    ;
R3L		equ 0x77		    ;

R4	    equ 0x78			    ; R4
R4H		equ 0x78		    ;
R4L		equ 0x79		    ;

R5	    equ 0x7A			    ; R5
R5H		equ 0x7A		    ;
R5L		equ 0x7B		    ;

R6	    equ 0x7C			    ; R6
R6H		equ 0x7C		    ;
R6L		equ 0x7D		    ;

R7	    equ 0x7E			    ; R7
R7H		equ 0x7E		    ;
R7L		equ 0x7F		    ;

;============================================================================
;   Interrupts disable
;============================================================================
CLI     MACRO
        BCF INTCON,GIE
        ENDM

;============================================================================
;   Interrupts enable
;============================================================================
SEI     MACRO
        BSF INTCON,GIE
        ENDM

;============================================================================
;   AND file to file
;============================================================================
ANDFF MACRO File1,File2

        MOVF File2,W                    ;Load File2
        ANDWF File1,F                   ;AND and result in File1

        ENDM

;============================================================================
;   AND literal to file
;============================================================================
ANDLF MACRO Lab,File

	MOVLW Lab			;Load literal
	ANDWF File,F			;AND and result in File

	ENDM


;============================================================================
;   Move file to file
;============================================================================

MOVFF   MACRO Src,Dst

        MOVF Src,W			;Load source
        MOVWF Dst                       ;Write into destination

        ENDM

;============================================================================
;   Move constant into byte
;============================================================================

MOVLF   MACRO Lab,Dst

        MOVLW Lab                       ;Load source
        MOVWF Dst                       ;Write into destination

        ENDM

;============================================================================
;   Move constant into word
;============================================================================
MOVL2W  MACRO Lab,Dst

        MOVLW HIGH Lab                  ;Load MSB
        MOVWF Dst                       ;Write into destination
        MOVLW LOW Lab                   ;Load LSB
        MOVWF Dst+1                     ;Write into destination

        ENDM

;****************************************************************************
;                            WORD INSTRUCTIONS
;****************************************************************************
;------------------------------------------------------------------------------
;   Test
;------------------------------------------------------------------------------
TSTW    MACRO What

        TSTF What                       ;Test MSB
        SKPNZ                           ;
        TSTF What+1                     ;Test LSB

        ENDM

;------------------------------------------------------------------------------
;   Decrement
;------------------------------------------------------------------------------
DECW    MACRO What

        TSTF What+1                     ;LSB not null ?
        SKPNZ                           ;
        DECF What,F                     ;YES: Decrement MSB
        DECF What+1,F                   ;Decrement LSB

        ENDM

;------------------------------------------------------------------------------
;   Increment
;------------------------------------------------------------------------------
INCW    MACRO What

        INCF  What+1,F                  ;Increment LSB
        SKPNZ                           ;Carry ?
        INCF  What,F                    ;YES: Increment MSB

        ENDM

;------------------------------------------------------------------------------
;    Sum Word with Byte -> Wo = Wo + By
;------------------------------------------------------------------------------
ADDWB   MACRO Wo,By

        MOVFW By                        ;Add LSB
        ADDWF Wo+1,F                    ;
        SKPNC                           ;Carry ?
        INCF Wo,F                       ;YES: Increment MSB

        ENDM

;------------------------------------------------------------------------------
;    Sum two Words -> Wo_A = Wo_A + Wo_B
;------------------------------------------------------------------------------
ADDW    MACRO Wo_A,Wo_B

        MOVFW Wo_B+1                    ;Add LSB
        ADDWF Wo_A+1,F                  ;
        SKPNC                           ;Carry ?
        INCF Wo_A,F                     ;YES: Increment MSB
        MOVFW Wo_B                      ;Add MSB
        ADDWF Wo_A,F                    ;

        ENDM

;------------------------------------------------------------------------------
;    Sum Word with Literal -> Wo = Wo + Lt
;------------------------------------------------------------------------------
ADDWL   MACRO Wo,Lt

        MOVLW LOW Lt                    ;Add LSB
        ADDWF Wo+1,F                    ;
        SKPNC                           ;Carry ?
        INCF Wo,F                       ;YES: Increment MSB
        MOVLW HIGH Lt                   ;Add MSB
        ADDWF Wo,F                      ;

        ENDM

;------------------------------------------------------------------------------
;    Sum Byte with Literal -> By = By + Lt
;------------------------------------------------------------------------------
ADDLF   MACRO Lt,By

        MOVLW Lt                        ;Add
        ADDWF By,F                      ;

        ENDM

;------------------------------------------------------------------------------
;    Subtract Words -> Wo_A = Wo_A - Wo_B
;------------------------------------------------------------------------------
SUBW    MACRO Wo_A,Wo_B

        MOVFW Wo_B+1                    ;Subtract LSB
        SUBWF Wo_A+1,F                  ;
        SKPC                            ;Carry ?
        DECF Wo_A,F                     ;YES: Decrement MSB
        MOVFW Wo_B                      ;Subtract MSB
        SUBWF Wo_A,F                    ;

        ENDM

;------------------------------------------------------------------------------
;    Subtract Byte from Word -> Wo = Wo - By
;------------------------------------------------------------------------------
SUBWB   MACRO Wo,By

        MOVF By,w                       ;Subtract LSB
        SUBWF Wo+1,F                    ;
        SKPC                            ;Carry ?
        DECF Wo,F                       ;YES: Decrement MSB

        ENDM

;------------------------------------------------------------------------------
;    Subtract Literal from Word -> Wo = Wo - Lt
;------------------------------------------------------------------------------
SUBWL   MACRO Wo,Lt

        MOVLW LOW Lt                    ;Subtract LSB
        SUBWF Wo+1,F                    ;
        SKPC                            ;Carry ?
        DECF Wo,F                       ;YES: Decrement MSB
        MOVLW HIGH Lt                   ;Subtract MSB
        SUBWF Wo,F                      ;

        ENDM

;****************************************************************************
;                               COMPARES
;****************************************************************************
;------------------------------------------------------------------------------
;   Compare two bytes (By_B - By_A)
;------------------------------------------------------------------------------
CMPB    MACRO By_A,By_B

        MOVFW By_A                      ;Load Byte
        SUBWF By_B,W                    ;Subtract in W

        ENDM

;------------------------------------------------------------------------------
;   Compare byte / literal (Lt - By)
;------------------------------------------------------------------------------
CMPBL   MACRO By,Lt

        MOVFW By                        ;Load Byte
        SUBLW Lt                        ;Subtract

        ENDM

;------------------------------------------------------------------------------
;   Compare two words (Wo_B - Wo_A)
;------------------------------------------------------------------------------
CMPW    MACRO Wo_A,Wo_B

        MOVFW Wo_A                      ;Compare MSB
        SUBWF Wo_B,W                    ;

        BNC $+5                         ;Wo_B < Wo_A
        BNZ $+3                         ;Wo_B > Wo_A

        MOVFW Wo_A+1                    ;Compare LSB
        SUBWF Wo_B+1,W                  ;

        ENDM

;****************************************************************************
;                             CONDITIONAL BRANCHES
;****************************************************************************
;Microchip assembler includes some branch macros:
;   B       :       Branch
;   BC      :       Branch on Carry
;   BDC     :       Branch on Digit Carry
;   BNC     :       Branch on No Carry
;   BNDC    :       Branch on No Digit Carry
;   BNZ     :       Branch on No Zero
;   BZ      :       Branch on Zero
;
;Here we add some additional "instructions" based on number comparison
;   BEQ     :       Branch if Equal
;   BNE     :       Branch if Not Equal
;   BG      :       Branch if Great
;   BGE     :       Branch if Great or Equal
;   BL      :       Branch if Less
;   BLE     :       Branch if Less or Equal

;------------------------------------------------------------------------------
;   Branch if Equal
;------------------------------------------------------------------------------
BEQ     MACRO label

        BZ label

        ENDM

;------------------------------------------------------------------------------
;   Branch if Not Equal
;------------------------------------------------------------------------------
BNE     MACRO label

        BNZ label

        ENDM

;------------------------------------------------------------------------------
;   Branch if Great
;------------------------------------------------------------------------------
BG      MACRO label

        BZ $+3
        BC label

        ENDM

;------------------------------------------------------------------------------
;   Branch if Great or Equal
;------------------------------------------------------------------------------
BGE     MACRO label

        BC label

        ENDM

;------------------------------------------------------------------------------
;   Branch if Less
;------------------------------------------------------------------------------
BL      MACRO label

        BZ $+3
        BNC label

        ENDM

;------------------------------------------------------------------------------
;   Branch if Less or Equal
;------------------------------------------------------------------------------
BLE     MACRO label

        BZ label
        BNC label

        ENDM

;    LIST
