;*****************************************************************************
;*                                                                           *
;* Display prototyping board basic                                           *
;* Copyright (C) 2022 by Walter Lain <kcswalter@member.fsf.org>              *
;*                                                                           *
;* This program is free software; you can redistribute it and/or modify      *
;* it under the terms of the GNU General Public License as published by      *
;* the Free Software Foundation; either version 3 of the License, or         *
;* (at your option) any later version.                                       *
;*                                                                           *
;* This program is distributed in the hope that it will be useful,           *
;* but WITHOUT ANY WARRANTY; without even the implied warranty of            *
;* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the               *
;* GNU General Public License for more details.                              *
;*                                                                           *
;* You should have received a copy of the GNU General Public License         *
;* along with this program; if not, write to the Free Software               *
;* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA02111-1307USA     *
;*                                                                           *
;*****************************************************************************
; ________________________________________________
; |           Disp-proto main program            |
; |______________________________________________|
; |                   Src File                   |
; |______________________________________________|
; |   Type      : ASM                            |
; |   Version   : 0                              |
; |   Release   : 1                              |
; |   Author    : Lain Walter                    |
; |   Date      : 14/03/22                       |
; |______________________________________________|


    LIST p=PIC16F18877, c=80, r=HEX, x=ON

#include <p16f18877.inc>

; CONFIG1
; External Oscillator mode selection bits (Oscillator not enabled)
; Power-up default value for COSC bits (FOSC=32MHz, HFINTOSC with 2x PLL, OSCFRQ= 16 MHz and CDIV = 1:1)
; Clock Out Enable bit (CLKOUT function is disabled; i/o or oscillator function on OSC2)
; Clock Switch Enable bit (Writing to NOSC and NDIV is allowed)
; Fail-Safe Clock Monitor Enable bit (FSCM timer enabled)
; __config 0x3F9C
 __CONFIG _CONFIG1, _FEXTOSC_OFF & _RSTOSC_HFINTPLL & _CLKOUTEN_OFF & _CSWEN_ON & _FCMEN_ON

; CONFIG2
; Master Clear Enable bit (MCLR pin is Master Clear function)
; Power-up Timer Enable bit (PWRT enabled)
; Low-Power BOR enable bit (ULPBOR disabled)
; Brown-out reset enable bits (Brown-out Reset Enabled, SBOREN bit is ignored)
; Brown-out Reset Voltage Selection (Brown-out Reset Voltage (VBOR) set to 1.9V on LF, and 2.45V on F Devices)
; Zero-cross detect disable (Zero-cross detect circuit is disabled at POR.)
; Peripheral Pin Select one-way control (The PPSLOCK bit can be set and cleared repeatedly by software)
; Stack Overflow/Underflow Reset Enable bit (Stack Overflow or Underflow will cause a reset)
; __config 0x37FD
 __CONFIG _CONFIG2, _MCLRE_ON & _PWRTE_ON & _LPBOREN_OFF & _BOREN_ON & _BORV_LO & _ZCD_OFF & _PPS1WAY_OFF & _STVREN_ON

; CONFIG3
; WDT Period Select bits (Divider ratio 1:65536)
; WDT operating mode (WDT enabled/disabled by SWDTEN bit in WDTCON0)
; WDT Window Select bits (Window always open (100%); software control; keyed access not required)
; WDT input clock selector (Software controlled)
; __config 0x3FAB
 __CONFIG _CONFIG3, _WDTCPS_WDTCPS_11 & _WDTE_SWDTEN & _WDTCWS_WDTCWS_7 & _WDTCCS_SC

; CONFIG4
; UserNVM self-write protection bits (NVM not write protected)
; Scanner Enable bit (Scanner module is available for use)
; Low Voltage Programming Enable bit (Low Voltage programming enabled. MCLR/Vpp pin function is MCLR.)
; __config 0x3FFF
 __CONFIG _CONFIG4, _WRT_OFF & _SCANE_available & _LVP_ON

; CONFIG5
; UserNVM Program memory code protection bit (UserNVM code protection disabled)
; DataNVM code protection bit (Data EEPROM code protection disabled)
; __config 0x3FFF
 __CONFIG _CONFIG5, _CP_OFF & _CPD_OFF

#include "macro_16F18.inc"

;***************************************************************************
;                               VARIABLES
;***************************************************************************
    UDATA
;---------------------------------------------------------------------Bank 0
        BANK_0
	#include "src/def_timer.inc"
	#include "src/def_io.inc"
	#include "src/def_ana.inc"
	#include "src/def_display.inc"
	#include "src/def_system.inc"
	BYTE LAST			;last byte bank 0

 ;***************************************************************************
;                                   RESET
;***************************************************************************

RES_VECT  CODE 0x0000			;RESET VECTOR
	GOTO SYS_STARTUP


;***************************************************************************
;                                INTERRUPTS
;***************************************************************************

INT_VECT CODE 0x0004			;INTERRUPT_VECTOR
	CLI				;Disable all IRQs
	BCF PCLATH,3			;Page 0
Tmr1_Int				;Main timer management
	BANKSEL PIR4			;Bank 14
	BTFSS PIR4,TMR1IF		;Check if TIMER1 is in OVF
	GOTO End_Int			; NO
	BCF PIR4,TMR1IF			; YES, clear Timer1 IRQ flag
	BANKSEL T1CON			;Bank 4
	BCF T1CON,TMR1ON		;Disable Timer1
	ADDLF c_TMR1_TIME_H,TMR1H	;Reset Timer1 duration
	ADDLF c_TMR1_TIME_L,TMR1L	;
	BSF T1CON,TMR1ON		;Enable Timer1
	BANKSEL b_TMR_STAT		;Bank 0
	BSF f_IRQ_TIMER1_ON		;Set Timer1 IRQ flag
End_Int	
	BANKSEL PORTA			;Bank 0
	RETFIE

MAIN_PROG CODE
;***************************************************************************
;                             SYSTEM START-UP
;***************************************************************************
SYS_STARTUP
	CLI				;Disable all IRQs
	CALL Sys_Init			;System init
	CALL Timer_Init			;Timer init
	CALL Io_Init			;I/O init
	CALL Ana_Init			;ADC init
	CALL Disp_Init			;Display init (will take about 110ms)
;add other init functions here

;***************************************************************************
;                           MAIN PROGRAM
;***************************************************************************
PROGRAM
	BANKSEL T1CON			;Bank 4
	BSF T1CON,TMR1ON		;Enable Timer1
	BANKSEL b_TMR_STAT		;Bank 0
	BSF INTCON,PEIE			;Enable peripheral interrupts
	SEI				;Enable all interrupts

;MAIN LOOP. MCU keeps cycling here
Main_Loop
	BANKSEL b_TMR_STAT		;Bank 0
	BTFSC f_IRQ_TIMER1_ON		;Check if Timer1 IRQ
	GOTO Fast_Ck1			; Yes
	GOTO Main_Loop			; No, repeat

;*******************************************************
;FAST LOOP 1 - 5ms
;*******************************************************
Fast_Ck1	
	BCF f_IRQ_TIMER1_ON		;Clear Timer1 IRQ flag
;add subs here
	CALL Ana_Read			;Read analog
	CALL Push_Read			;Read pushbuttons
	BTFSC f_CK1_DIV			;Check if fast loop 2
	GOTO Fast_Ck2			; Yes, go to fast loop 2
	BSF f_CK1_DIV			; No, set next time
	GOTO Main_Loop			; Repeat

;*******************************************************
;FAST LOOP 2 - 10 ms
;*******************************************************
Fast_Ck2
;add subs here
	BCF f_CK1_DIV			;Clear fast loop 2 flag

;*******************************************************
;SLOW LOOP 1 - 100 ms
;*******************************************************
Low_Ck1
	DECFSZ b_TMR7_CNT,f		;Decrement slow timer 7
	GOTO Main_Loop			; if not zero, skip
	MOVLF c_TMR7_DIV,b_TMR7_CNT	; zero, reloads timer
;add subs here
	CALL Disp_Write			;Write on display
	CALL Disp_WrPb			;Write push status on display
	GOTO Main_Loop			;Repeat

;***************************************************************************
;                               INCLUDE FILES
;***************************************************************************
;---------------------------------------------------------------------Page 0
#include "src/asm_timer.asm"
#include "src/asm_io.asm"
#include "src/asm_ana.asm"
#include "src/asm_display.asm"
#include "src/asm_system.asm"
;;---------------------------------------------------------------------Page 1
;    CODE 0x0800
;;---------------------------------------------------------------------Page 2
;    CODE 0x1000
;;---------------------------------------------------------------------Page 3
;    CODE 0x1800
;;---------------------------------------------------------------------Page 4
;    CODE 0x2000
;;---------------------------------------------------------------------Page 5
;    CODE 0x2800
;;---------------------------------------------------------------------Page 6
;    CODE 0x3000
;;---------------------------------------------------------------------Page 7
;    CODE 0x3800
;;---------------------------------------------------------------------Page 8
;    CODE 0x4000
;;---------------------------------------------------------------------Page 9
;    CODE 0x4800
;;---------------------------------------------------------------------Page 10
;    CODE 0x5000
;;---------------------------------------------------------------------Page 11
;    CODE 0x5800
;;---------------------------------------------------------------------Page 12
;    CODE 0x6000
;;---------------------------------------------------------------------Page 13
;    CODE 0x6800
;;---------------------------------------------------------------------Page 14
;    CODE 0x7000
;;---------------------------------------------------------------------Page 15
;    CODE 0x7800

        END
