;*****************************************************************************
;*                                                                           *
;* Display prototyping board basic                                           *
;* Copyright (C) 2022 by Walter Lain <kcswalter@member.fsf.org>              *
;*                                                                           *
;* This program is free software; you can redistribute it and/or modify      *
;* it under the terms of the GNU General Public License as published by      *
;* the Free Software Foundation; either version 3 of the License, or         *
;* (at your option) any later version.                                       *
;*                                                                           *
;* This program is distributed in the hope that it will be useful,           *
;* but WITHOUT ANY WARRANTY; without even the implied warranty of            *
;* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
;* GNU General Public License for more details.                              *
;*                                                                           *
;* You should have received a copy of the GNU General Public License         *
;* along with this program; if not, write to the Free Software               *
;* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
;*                                                                           *
;*****************************************************************************

; ________________________________________________
; |        Analog routines for Disp-proto        |
; |______________________________________________|
; |   Src File                                   |
; |______________________________________________|
; |   Type      : ASM                            |
; |   Version   : 0                              |
; |   Release   : 1                              |
; |   Author    : Lain Walter                    |
; |   Date      : 14/03/22                       |
; |______________________________________________|

;_______________________________________________________Analog init
;Initialize analog subsystem
;Modified registers:
;	system
;Call method
;	CALL Ana_Init
Ana_Init:
        BANKSEL ADCON0			;Bank 1
	MOVLF c_ADCON0,ADCON0		;Configure ADC module
	MOVLF c_ADCON1,ADCON1		;
	MOVLF c_ADCON2,ADCON2		;
	MOVLF c_ADCON3,ADCON3		;
	MOVLF c_ADCLK,ADCLK		;
	MOVLF c_ADREF,ADREF		;
	MOVLF c_ADPCH,ADPCH		;
	BSF ADCON0,ADGO			;Start ADC
	BANKSEL PORTA			;Bank 0
	RETURN

;_______________________________________________________Analog read
;Read analog ports
;FOR PUSHBUTTONS, to filter noise, divide by 4 (2x right shift with carry), then these
; are the button setpoints:
;   P1: 43-49
;   P2: 88-94
;   P3: 125-131
;   P4: 168-174
;   I'll keep a fork of 3 + and - on the reading point, so I should not get any problem.
;   Note: must not take an averaged reading, otherwise it will became a mess during level
;    shifts. I'll use a simple push buffer, as done for digital buttons, for bounce
;    filtering
;Modified registers:
;	system
;	R0H
;	R0L
;	b_ANA_PUSH
;	b_ANA_STAT
;Call method
;	CALL Ana_Read
Ana_Read:
        BANKSEL PORTA			;Bank 0
	BTFSC f_ANA_FIRST		;Check if first read
	GOTO AN_RD1			; Yes
	BANKSEL ADRESL			; No, Bank 1
	MOVFF ADRESH,R0H		;  Read MSB
	MOVFF ADRESL,R0L		;  Read LSB
	CLRC				;  Divide result by 4
	RRF R0H,f			;
	RRF R0L,f			;
	CLRC				;
	RRF R0H,f			;
	RRF R0L,f			;Now the result is an 8bit in R0L
        BANKSEL PORTA			;Bank 0
	MOVFF R0L,b_ANA_PUSH		;Save the result
	RETURN
AN_RD1	CLRF b_ANA_PUSH			;Clear result
	BCF f_ANA_FIRST			;Clear first read
	RETURN
