;*****************************************************************************
;*                                                                           *
;* Display prototyping board basic                                           *
;* Copyright (C) 2022 by Walter Lain <kcswalter@member.fsf.org>              *
;*                                                                           *
;* This program is free software; you can redistribute it and/or modify      *
;* it under the terms of the GNU General Public License as published by      *
;* the Free Software Foundation; either version 3 of the License, or         *
;* (at your option) any later version.                                       *
;*                                                                           *
;* This program is distributed in the hope that it will be useful,           *
;* but WITHOUT ANY WARRANTY; without even the implied warranty of            *
;* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
;* GNU General Public License for more details.                              *
;*                                                                           *
;* You should have received a copy of the GNU General Public License         *
;* along with this program; if not, write to the Free Software               *
;* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
;*                                                                           *
;*****************************************************************************

; ________________________________________________
; |        Display routines for Disp-proto       |
; |______________________________________________|
; |   Src File                                   |
; |______________________________________________|
; |   Type      : ASM                            |
; |   Version   : 0                              |
; |   Release   : 1                              |
; |   Author    : Lain Walter                    |
; |   Date      : 14/03/22                       |
; |______________________________________________|

;_______________________________________________________Display init
;Initialize display subsystem
;Modified registers:
;	system
;	R0H
;	(R0L)
;	(R1H)
;	R1L
;Call method
;	CALL Disp_Init
Disp_Init:
	BANKSEL c_LCD_EN_PORT		;Bank 0
	BSF c_LCD_BL_PORT,c_LCD_BL_PIN	;Switch off LCD backlight
	BCF c_LCD_EN_PORT,c_LCD_EN_PIN	;Set "function set"
	BCF c_LCD_RS_PORT,c_LCD_RS_PIN	;
	BCF c_LCD_RW_PORT,c_LCD_RW_PIN	;
	MOVLW c_LCDTRIS_DO		;Set LCD data bus as output
	ANDWF c_LCD_D_LATC,f		;Clear data bus latch
	ANDWF c_LCD_D_TRIS,f		;Data bus as output
	ANDWF c_LCD_D_PORT,f		;Clear data bus port
	CALL Disp_Ck100ms		;ON wait loop >40ms (100ms)
	MOVLF c_DISP_INIT1,R1L		;Load function set 1 (wake-up)
	CALL Disp_WrNibble		;Write display in 4 bit
	CALL Disp_Ck38us		;
	MOVLF c_DISP_INIT2A,R1L		;Load function set 2 (4-bit mode)
	CALL Disp_WrNibble		;Write display in 4 bit
	MOVLF c_DISP_INIT2B,R1L		;Load function set 2 (4-bit mode)
	CALL Disp_WrNibble		;Write display in 4 bit
	CALL Disp_Ck38us		;
	MOVLF c_DISP_INIT2A,R1L		;Load again function set 2 (4-bit mode)
	CALL Disp_WrNibble		;Write display in 4 bit
	MOVLF c_DISP_INIT2B,R1L		;Load again function set 2 (4-bit mode)
	CALL Disp_WrNibble		;Write display in 4 bit
	CALL Disp_Ck38us		;
	MOVLF c_DISP_CMDA,R1L		;Load command
	CALL Disp_WrNibble		;Write display in 4 bit
;	MOVLF c_DISP_ONSCSBB,R1L	;Load Display control, display ON, cursor ON and blinking
	MOVLF c_DISP_ONNCNBB,R1L	;Load Display control, display ON, cursor+blink OFF
	CALL Disp_WrNibble		;Write display in 4 bit
	CALL Disp_Ck38us		;
	MOVLF c_DISP_CMDA,R1L		;Load command
	CALL Disp_WrNibble		;Write display in 4 bit
	MOVLF c_DISP_CLRB,R1L		;Load Display clear command
	CALL Disp_WrNibble		;Write display in 4 bit
	CALL Disp_Ck2ms			;
	MOVLF c_DISP_CMDA,R1L		;Load command
	CALL Disp_WrNibble		;Write display in 4 bit
	MOVLF c_DISP_MODEB,R1L		;Load Display mode set, cursor increment, no shift
	CALL Disp_WrNibble		;Write display in 4 bit
	CALL Disp_Ck38us		;
	MOVLW c_LCDTRIS_DI		;Set LCD data bus as input (I want it as idle state of the bus)
	IORWF c_LCD_D_TRIS,f		;Data bus as output
	RETURN

;_______________________________________________________Display write nibble (4 bit comm)
;Routine to send data in 2 nibbles to display
;Modified registers:
;	System
;	(R0H)
;	(R0L)
;	(R1H)
;	R1L
;Call method
;	MOVFF DATA,R1L
;	CALL Disp_WrNibble
Disp_WrNibble:
	BANKSEL c_LCD_EN_PORT		;Bank 0
	MOVF c_LCD_D_PORT,w		;Load current PORT value
	ANDLW c_DISP_ANDMSK		;Clear data bus bits
	IORWF R1L,w			;Load data/command
	MOVWF c_LCD_D_LATC		;Write on bus
	NOP				;Wait settle time
	BSF c_LCD_EN_PORT,c_LCD_EN_PIN	;Set Enable
	CALL Disp_Ck625ns		;Wait to comply with display timings (>460ns)
	BCF c_LCD_EN_PORT,c_LCD_EN_PIN	;Clear Enable
	RETURN

;_______________________________________________________Display write command
;Routine to send commands to display
;Modified registers:
;	System
;	R0H
;	R0L
;	(R7H)
;	(R7L)
;Call method
;	MOVFF COMMAND,R0H
;	CALL Disp_WrCmd
Disp_WrCmd:
	BANKSEL c_LCD_EN_PORT		;Bank 0
	CALL Disp_WaitBF		;Wait for LCD to be available
	BCF c_LCD_RS_PORT,c_LCD_RS_PIN	;Put LCD in command write mode
	BCF c_LCD_RW_PORT,c_LCD_RW_PIN	;
DI_WRT	MOVLW c_LCDTRIS_DO		;Set LCD data bus as output
	ANDWF c_LCD_D_LATC,f		;Clear data bus latch
	ANDWF c_LCD_D_TRIS,f		;Data bus as output
	ANDWF c_LCD_D_PORT,f		;Clear data bus port
DI_WR2	SWAPF R0H,w			;Swap nibbles (send MSN first)
	ANDLW c_DISP_ANDMSKL		;Clear MSNibble
	MOVWF R0L			;Save in temp			
	MOVF c_LCD_D_PORT,w		;Load current PORT value
	ANDLW c_DISP_ANDMSK		;Clear data bus bits
	IORWF R0L,w			;Load data/command MSN
	MOVWF c_LCD_D_LATC		;Write on bus
	NOP				;Wait settle time
	BSF c_LCD_EN_PORT,c_LCD_EN_PIN	;Set Enable
	CALL Disp_Ck625ns		;Wait to comply with display timings (>460ns)
	BCF c_LCD_EN_PORT,c_LCD_EN_PIN	;Clear Enable
	MOVF R0H,w			;Reload data (send LSN second)
	ANDLW c_DISP_ANDMSKL		;Clear MSNibble
	MOVWF R0L			;Save in temp			
	MOVF c_LCD_D_PORT,w		;Load current PORT value
	ANDLW c_DISP_ANDMSK		;Clear data bus bits
	IORWF R0L,w			;Load data/command LSN
	MOVWF c_LCD_D_LATC		;Write on bus
	NOP				;Wait settle time
	BSF c_LCD_EN_PORT,c_LCD_EN_PIN	;Set Enable
	CALL Disp_Ck625ns		;Wait to comply with display timings (>460ns)
	BCF c_LCD_EN_PORT,c_LCD_EN_PIN	;Clear Enable
	CALL Disp_Ck38us		;Wait >37us (50us)
	BSF c_LCD_RS_PORT,c_LCD_RS_PIN	;Put LCD in read mode
	BSF c_LCD_RW_PORT,c_LCD_RW_PIN	;
	MOVLW c_LCDTRIS_DI		;Set LCD data bus as input (I want it as idle state of the bus)
	IORWF c_LCD_D_TRIS,f		;Data bus as input
	RETURN

;_______________________________________________________Display write data
;Routine to send data to display
;Modified registers:
;	System
;	(R0H)
;	(R7H)
;	(R7L)
;Call method
;	MOVFF DATA,R0H
;	CALL Disp_WrData
Disp_WrData:
	BANKSEL c_LCD_EN_PORT		;Bank 0
        CALL Disp_WaitBF		;Wait for LCD to be available
	BSF c_LCD_RS_PORT,c_LCD_RS_PIN	;Put LCD in data write mode
	BCF c_LCD_RW_PORT,c_LCD_RW_PIN	;
	GOTO DI_WRT			;Write the data on the bus

;_______________________________________________________Display address set
;Routine to select the LCD DDRAM address
;Modified registers:
;	System
;	R0H
;	(R7H)
;	(R7L)
;Call method
;	MOVFF ADDRESS,R0H
;	CALL Disp_SetAdd
Disp_SetAdd:
	BANKSEL c_LCD_EN_PORT		;Bank 0
	BSF R0H,7			;Bit7 must be 1
	GOTO Disp_WrCmd			;Then treat it as a command

;_______________________________________________________Display wait available
;Routine to wait until LCD is available. Be aware that this will just keep the
; MCU in loop until busy flag is CLEAR. If flag is not clear after 200us (should
; not need more than 80us), it will just exit anyway.
;Modified registers:
;	System
;	R7H
;	R7L
;Call method
;	CALL Disp_WaitBF
Disp_WaitBF:
	BANKSEL c_LCD_EN_PORT		;Bank 0
	MOVLF c_DISP_TOUT,R7L		;Set timeout at 200us
	MOVLW c_LCDTRIS_DI		;Set LCD data bus as input (I want it as idle state of the bus)
	IORWF c_LCD_D_TRIS,f		;Data bus as input
	BCF c_LCD_RS_PORT,c_LCD_RS_PIN	;Put LCD in busy read mode
	BSF c_LCD_RW_PORT,c_LCD_RW_PIN	;
D_WBF	DECFSZ R7L,f			;Check if timeout - Will wait 200us if R7L is 80
	GOTO D_WBL			; No, keep checking
	GOTO D_WBZ			; Yes, exit loop. I should't be stuck here too long
D_WBL	CALL Disp_Ck625ns		;Wait to comply with display timings (>460ns)
	BSF c_LCD_EN_PORT,c_LCD_EN_PIN	;Set Enable
	CALL Disp_Ck625ns		;Wait to comply with display timings (>460ns)
	MOVFF c_LCD_D_PORT,R7H		;Read status
	BCF c_LCD_EN_PORT,c_LCD_EN_PIN	;Clear Enable
	BTFSC R7H,7			;Check if it is busy
	GOTO D_WBF			; Yes, go back
D_WBZ	BSF c_LCD_RS_PORT,c_LCD_RS_PIN	; No, put LCD in read mode
	BSF c_LCD_RW_PORT,c_LCD_RW_PIN	;
	RETURN

;_______________________________________________________Write all display
;Routine to write all display data at once
;Modified registers:
;	System
;	R0H
;	(R0L)
;	(R1H)
;	(R1L)
;	(R2H)
;	(R2L)
;	(R3H)
;	(R7H)
;	(R7L)
;	b_SYS_FLAGS
;Call method
;	BSF f_LCD_REFSH
;	CALL Disp_Write
Disp_Write:
	BANKSEL c_LCD_EN_PORT		;Bank 0
	BTFSS f_LCD_REFSH		;Check if needed (only at startup and after a pulse)
	RETURN				; No
	BCF f_LCD_REFSH			; Yes, clear flag
	MOVLF c_ROW1_ADDR,R0H		;Move the pointer back to first position of row 1
	CALL Disp_SetAdd		;
	MOVLF c_CHAR_LCD_ASTR,R0H	;Load the first row
	CALL Disp_WrData		;**Display test**
	MOVLF c_CHAR_LCD_ASTR,R0H	;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_D,R0H		;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_i,R0H		;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_s,R0H		;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_p,R0H		;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_l,R0H		;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_a,R0H		;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_y,R0H		;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_SPC,R0H	;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_t,R0H		;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_e,R0H		;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_s,R0H		;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_t,R0H		;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_ASTR,R0H	;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_ASTR,R0H	;
	CALL Disp_WrData		;
	MOVLF c_ROW2_ADDR,R0H		;Move the pointer to first position of row 2
	CALL Disp_SetAdd		;
	MOVLF c_CHAR_LCD_P,R0H		;P1:
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_1,R0H		;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_COLN,R0H	;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_SPC,R0H	;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_P,R0H		;P2:
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_2,R0H		;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_COLN,R0H	;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_SPC,R0H	;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_P,R0H		;P3:
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_3,R0H		;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_COLN,R0H	;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_SPC,R0H	;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_P,R0H		;P4:
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_4,R0H		;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_COLN,R0H	;
	CALL Disp_WrData		;
	MOVLF c_CHAR_LCD_SPC,R0H	;
	CALL Disp_WrData		;
	RETURN

;_______________________________________________________Write pushbutton status
;Routine to write pushbutton status on display
;Modified registers:
;	System
;	R0H
;	(R0L)
;	(R1H)
;	(R1L)
;	(R2H)
;	(R2L)
;	(R3H)
;	(R7H)
;	(R7L)
;Call method
;	CALL Disp_WrPb
Disp_WrPb:
	BANKSEL c_LCD_EN_PORT		;Bank 0
	MOVLF c_P1ST_ADDR,R0H		;Move the pointer to Push 1 status
	CALL Disp_SetAdd		;
	BTFSC f_PUSH1_HI		;Check Push 1 status
	GOTO DWP_P1S			; Set
	MOVLF c_CHAR_LCD_SPC,R0H	; Clear, write space
	CALL Disp_WrData		;
	BSF c_LCD_BL_PORT,c_LCD_BL_PIN	;Switch off LCD backlight
	GOTO DWP_P2			; Go to Push 2 status
DWP_P1S	MOVLF c_CHAR_LCD_ASTR,R0H	;Write *
	CALL Disp_WrData		;
	BCF c_LCD_BL_PORT,c_LCD_BL_PIN	;Switch on LCD backlight
DWP_P2	MOVLF c_P2ST_ADDR,R0H		;Move the pointer to Push 2 status
	CALL Disp_SetAdd		;
	BTFSC f_PUSH2_HI		;Check Push 2 status
	GOTO DWP_P2S			; Set
	MOVLF c_CHAR_LCD_SPC,R0H	; Clear, write space
	CALL Disp_WrData		;
	GOTO DWP_P3			; Go to Push 3 status
DWP_P2S	MOVLF c_CHAR_LCD_ASTR,R0H	;Write *
	CALL Disp_WrData		;
DWP_P3	MOVLF c_P3ST_ADDR,R0H		;Move the pointer to Push 3 status
	CALL Disp_SetAdd		;
	BTFSC f_PUSH3_HI		;Check Push 3 status
	GOTO DWP_P3S			; Set
	MOVLF c_CHAR_LCD_SPC,R0H	; Clear, write space
	CALL Disp_WrData		;
	GOTO DWP_P4			; Go to Push 4 status
DWP_P3S	MOVLF c_CHAR_LCD_ASTR,R0H	;Write *
	CALL Disp_WrData		;
DWP_P4	MOVLF c_P4ST_ADDR,R0H		;Move the pointer to Push 4 status
	CALL Disp_SetAdd		;
	BTFSC f_PUSH4_HI		;Check Push 4 status
	GOTO DWP_P4S			; Set
	MOVLF c_CHAR_LCD_SPC,R0H	; Clear, write space
	CALL Disp_WrData		;
	RETURN
DWP_P4S	MOVLF c_CHAR_LCD_ASTR,R0H	;Write *
	CALL Disp_WrData		;
	RETURN

;_______________________________________________________Byte conversion from binary to decimal
;Converts a byte from binary to 3-digit decimal
;Modified registers
;	system
;	b_BCD_HNDT
;	b_BCD_TENT
;	b_BCD_UNIT
;	R0H
;Call method
;	Write data into R0H 
;	CALL Byte_BCD
Byte_BCD:
	BANKSEL b_BCD_HNDT		;Bank 0
	CLRF b_BCD_HNDT			;Clear decimal address before updating it
	CLRF b_BCD_TENT			;
	CLRF b_BCD_UNIT			;
BCD_HUN	MOVLW .100			;
	SUBWF R0H,f			;Data -100 >= 0?
	BNC BCD_DEC			; No, Data lower than 100
	INCF b_BCD_HNDT,f		; Yes, Data greater than 100, Hundreds++
	GOTO BCD_HUN			; Repeat
BCD_DEC	MOVLW .100			;Restore correct Data value
	ADDWF R0H,f			;
BCD_DC2	MOVLW .10			;
	SUBWF R0H,w			;Data-10>0?
	BNC BCD_UNI			; No
	MOVWF R0H			; Yes, save
	INCF b_BCD_TENT,f		; Tents++
	GOTO BCD_DC2			; Repeat
BCD_UNI	MOVF R0H,w			;Data=0?
	BZ BCD_END			; Yes
BCD_UN2	INCF b_BCD_UNIT,f		; No, units++
	DECFSZ R0H,f			; Data-1=0?
	GOTO BCD_UN2			;  No,repeat
BCD_END	RETURN				;  Yes, exit
