;*****************************************************************************
;*                                                                           *
;* Display prototyping board basic                                           *
;* Copyright (C) 2022 by Walter Lain <kcswalter@member.fsf.org>              *
;*                                                                           *
;* This program is free software; you can redistribute it and/or modify      *
;* it under the terms of the GNU General Public License as published by      *
;* the Free Software Foundation; either version 3 of the License, or         *
;* (at your option) any later version.                                       *
;*                                                                           *
;* This program is distributed in the hope that it will be useful,           *
;* but WITHOUT ANY WARRANTY; without even the implied warranty of            *
;* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
;* GNU General Public License for more details.                              *
;*                                                                           *
;* You should have received a copy of the GNU General Public License         *
;* along with this program; if not, write to the Free Software               *
;* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
;*                                                                           *
;*****************************************************************************

; ________________________________________________
; |          I/O routines for Disp-proto         |
; |______________________________________________|
; |   Src File                                   |
; |______________________________________________|
; |   Type      : ASM                            |
; |   Version   : 0                              |
; |   Release   : 1                              |
; |   Author    : Lain Walter                    |
; |   Date      : 14/03/22                       |
; |______________________________________________|

;_______________________________________________________Ports init
;Clear PORTS and initialize all I/O related registers
;Modified registers:
;	system
;Call method
;	CALL Io_Init
Io_Init:
	BANKSEL PORTA			;Bank 0
	CLRF PORTA			;Clear PORTA
	CLRF PORTB			;Clear PORTB
	CLRF PORTC			;Clear PORTC
	CLRF PORTD			;Clear PORTD
	CLRF PORTE			;Clear PORTE
	CLRF LATA			;Clear PORTA Data Latch
	CLRF LATB			;Clear PORTB Data Latch
	CLRF LATC			;Clear PORTC Data Latch
	CLRF LATD			;Clear PORTD Data Latch
	CLRF LATE			;Clear PORTE Data Latch
	MOVLF c_TRISA,TRISA		;Set PORTA I/O
	MOVLF c_TRISB,TRISB		;Set PORTB I/O
	MOVLF c_TRISC,TRISC		;Set PORTC I/O
	MOVLF c_TRISD,TRISD		;Set PORTD I/O
	MOVLF c_TRISE,TRISE		;Set PORTE I/O
	BANKSEL ANSELA			;Bank 62
	MOVLF c_ANSA,ANSELA		;Set PORTA D/A mode
	MOVLF c_ANSB,ANSELB		;Set PORTB D/A mode
	MOVLF c_ANSC,ANSELC		;Set PORTC D/A mode
	MOVLF c_ANSD,ANSELD		;Set PORTD D/A mode
	MOVLF c_ANSE,ANSELE		;Set PORTE D/A mode
	MOVLF c_WPUA,WPUA		;Set PORTA Pull-Up mode
	MOVLF c_WPUB,WPUB		;Set PORTB Pull-Up mode
	MOVLF c_WPUC,WPUC		;Set PORTC Pull-Up mode
	MOVLF c_WPUD,WPUD		;Set PORTD Pull-Up mode
	MOVLF c_WPUE,WPUE		;Set PORTE Pull-Up mode
	MOVLF c_ODCA,ODCONA		;Set PORTA Open-Drain mode
	MOVLF c_ODCB,ODCONB		;Set PORTB Open-Drain mode
	MOVLF c_ODCC,ODCONC		;Set PORTC Open-Drain mode
	MOVLF c_ODCD,ODCOND		;Set PORTD Open-Drain mode
	MOVLF c_ODCE,ODCONE		;Set PORTE Open-Drain mode
	MOVLF c_SLRA,SLRCONA		;Set PORTA Slew Rate mode
	MOVLF c_SLRB,SLRCONB		;Set PORTB Slew Rate mode
	MOVLF c_SLRC,SLRCONC		;Set PORTC Slew Rate mode
	MOVLF c_SLRD,SLRCOND		;Set PORTD Slew Rate mode
	MOVLF c_SLRE,SLRCONE		;Set PORTE Slew Rate mode
	MOVLF c_INLVA,INLVLA		;Set PORTA Input level mode
	MOVLF c_INLVB,INLVLB		;Set PORTB Input level mode
	MOVLF c_INLVC,INLVLC		;Set PORTC Input level mode
	MOVLF c_INLVD,INLVLD		;Set PORTD Input level mode
	MOVLF c_INLVE,INLVLE		;Set PORTE Input level mode
	BANKSEL PORTA			;Bank 0
	RETURN

;_______________________________________________________Push read/management (analog and digital)
;Manages all analog and digital pushbuttons
;Modified registers:
;	system
;	b_SW_STAT
;	b_TMR_STAT
;	b_PUSH1_CNT
;	b_PUSH2_CNT
;	b_PUSH3_CNT
;	b_PUSH4_CNT
;Call method
;	CALL Push_Read
Push_Read:
	BANKSEL PORTA			;Bank 0
PR_ANA	MOVF b_ANA_PUSH,w		;Check analog level (find the pressed button)
	SUBLW c_PUSH4_HI		;
	BNC PR_HI			;Level over Push 4
	MOVF b_ANA_PUSH,w		;Reload
	SUBLW c_PUSH4_LO		;
	BNC PR_P4			;Pushbutton 4
	MOVF b_ANA_PUSH,w		;Reload
	SUBLW c_PUSH3_HI		;
	BNC PR_HI			;Level between push 3 and 4
	MOVF b_ANA_PUSH,w		;Reload
	SUBLW c_PUSH3_LO		;
	BNC PR_P3			;Pushbutton 3
	MOVF b_ANA_PUSH,w		;Reload
	SUBLW c_PUSH2_HI		;
	BNC PR_HI			;Level between push 2 and 3
	MOVF b_ANA_PUSH,w		;Reload
	SUBLW c_PUSH2_LO		;
	BNC PR_P2			;Pushbutton 2
	MOVF b_ANA_PUSH,w		;Reload
	SUBLW c_PUSH1_HI		;
	BNC PR_HI			;Level between push 1 and 2
	MOVF b_ANA_PUSH,w		;Reload
	SUBLW c_PUSH1_LO		; 
	BNC PR_P1			;Pushbutton 1
PR_HI	BCF f_PUSH_RPT			;Average outside pushbutton range, clear repeat
	MOVF b_PUSH1_CNT,w		;Decrement all push counters
	BNZ PR_L1Z			;Push 1 is not 0
	BCF f_PUSH1_HI			;Already 0, clear Push 1 high state
	GOTO PR_LW2			;Don't decrement
PR_L1Z	DECF b_PUSH1_CNT,f		;Not 0, decrement
PR_LW2	MOVF b_PUSH2_CNT,w		;Check Push 2 counter
	BNZ PR_L2Z			;Push 2 is not 0
	BCF f_PUSH2_HI			;Already 0, clear Push 2 high state
	GOTO PR_LW3			;Don't decrement
PR_L2Z	DECF b_PUSH2_CNT,f		;Not 0, decrement
PR_LW3	MOVF b_PUSH3_CNT,w		;Check Push 3 counter
	BNZ PR_L3Z			;Push 3 is not 0
	BCF f_PUSH3_HI			;Already 0, clear Push 3 high state
	GOTO PR_LW4			;Don't decrement
PR_L3Z	DECF b_PUSH3_CNT,f		;Not 0, decrement
PR_LW4	MOVF b_PUSH4_CNT,w		;Check Push 4 counter
	BNZ PR_L4Z			;Push 4 is not 0
	BCF f_PUSH4_HI			;Already 0, clear Push 4 high state
	RETURN
PR_L4Z	DECF b_PUSH4_CNT,f		;Not 0, decrement
	RETURN
PR_P1	INCF b_PUSH1_CNT,f		;Increment Push 1 counter
	MOVLW c_PUSH_HIF		;Check if counter at fast level
	SUBWF b_PUSH1_CNT,w		;
	BZ PR_P1A			; Yes
	BTFSS f_PUSH_RPT		; No, check if repeat is active
	GOTO PR_P1R			;  No
	BTFSS b_PUSH1_CNT,c_PUSH_RPT	;  Yes, check if counter at continuous repeat level
	RETURN				;   No
	CLRF b_PUSH1_CNT		;   Yes, reset counter
	RETURN
PR_P1R	BTFSS b_PUSH1_CNT,c_PUSH_HIR	; No, check if counter at first repeat level
	RETURN				;  No
	CLRF b_PUSH1_CNT		;  Yes, reset counter
	BSF f_PUSH_RPT			;  Activate repeat
	RETURN
PR_P1A	MOVLW c_PUSH_RES		; Clear Push states
	ANDWF b_SW_STAT			;
	BSF f_PUSH1_HI			; Set Push 1 high state
	RETURN
PR_P2	INCF b_PUSH2_CNT,f		;Increment Push 2 counter
	MOVLW c_PUSH_HIF		;Check if counter at fast level
	SUBWF b_PUSH2_CNT,w		;
	BZ PR_P2A			; Yes
	BTFSS f_PUSH_RPT		; No, check if repeat is active
	GOTO PR_P2R			;  No
	BTFSS b_PUSH2_CNT,c_PUSH_RPT	;  Yes, check if counter at continuous repeat level
	RETURN				;   No
	CLRF b_PUSH2_CNT		;   Yes, reset counter
	RETURN
PR_P2R	BTFSS b_PUSH2_CNT,c_PUSH_HIR	; No, check if counter at first repeat level
	RETURN				;  No
	CLRF b_PUSH2_CNT		;  Yes, reset counter
	BSF f_PUSH_RPT			;  Activate repeat
	RETURN				;
PR_P2A	MOVLW c_PUSH_RES		; Clear Push states
	ANDWF b_SW_STAT			;
	BSF f_PUSH2_HI			; Set Push 2 high state
	RETURN
PR_P3	INCF b_PUSH3_CNT,f		;Increment Push 3 counter
	MOVLW c_PUSH_HIF		;Check if counter at fast level
	SUBWF b_PUSH3_CNT,w		;
	BZ PR_P3A			; Yes
	BTFSS f_PUSH_RPT		; No, check if repeat is active
	GOTO PR_P3R			;  No
	BTFSS b_PUSH3_CNT,c_PUSH_RPT	;  Yes, check if counter at continuous repeat level
	RETURN				;   No
	CLRF b_PUSH3_CNT		;   Yes, reset counter
	RETURN
PR_P3R	BTFSS b_PUSH3_CNT,c_PUSH_HIR	; No, check if counter at first repeat level
	RETURN				;  No
	CLRF b_PUSH3_CNT		;  Yes, reset counter
	BSF f_PUSH_RPT			;  Activate repeat
	RETURN				;
PR_P3A	MOVLW c_PUSH_RES		; Clear Push states
	ANDWF b_SW_STAT			;
	BSF f_PUSH3_HI			; Set Push 3 high state
	RETURN
PR_P4	INCF b_PUSH4_CNT,f		;Increment Push 4 counter
	MOVLW c_PUSH_HIF		;Check if counter at fast level
	SUBWF b_PUSH4_CNT,w		;
	BZ PR_P4A			; Yes
	BTFSS f_PUSH_RPT		; No, check if repeat is active
	GOTO PR_P4R			;  No
	BTFSS b_PUSH4_CNT,c_PUSH_RPT	;  Yes, check if counter at continuous repeat level
	RETURN				;   No
	CLRF b_PUSH4_CNT		;   Yes, reset counter
	RETURN
PR_P4R	BTFSS b_PUSH4_CNT,c_PUSH_HIR	; No, check if counter at first repeat level
	RETURN				;  No
	CLRF b_PUSH4_CNT		;  Yes, reset counter
	BSF f_PUSH_RPT			;  Activate repeat
	RETURN				;
PR_P4A	MOVLW c_PUSH_RES		; Clear Push states
	ANDWF b_SW_STAT			;
	BSF f_PUSH4_HI			; Set Push 4 high state
	RETURN
