;*****************************************************************************
;*                                                                           *
;* Display prototyping board basic                                           *
;* Copyright (C) 2022 by Walter Lain <kcswalter@member.fsf.org>              *
;*                                                                           *
;* This program is free software; you can redistribute it and/or modify      *
;* it under the terms of the GNU General Public License as published by      *
;* the Free Software Foundation; either version 3 of the License, or         *
;* (at your option) any later version.                                       *
;*                                                                           *
;* This program is distributed in the hope that it will be useful,           *
;* but WITHOUT ANY WARRANTY; without even the implied warranty of            *
;* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
;* GNU General Public License for more details.                              *
;*                                                                           *
;* You should have received a copy of the GNU General Public License         *
;* along with this program; if not, write to the Free Software               *
;* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
;*                                                                           *
;*****************************************************************************

; ________________________________________________
; |        System routines for Disp-proto        |
; |______________________________________________|
; |   Src File                                   |
; |______________________________________________|
; |   Type      : ASM                            |
; |   Version   : 0                              |
; |   Release   : 1                              |
; |   Author    : Lain Walter                    |
; |   Date      : 14/03/22                       |
; |______________________________________________|

;_______________________________________________________System init
;Initialize all system related registers not managed elsewhere, and
; clear all RAM
;Modified registers:
;	system
;	RAM (all)
;Call method
;	CALL Sys_Init
Sys_Init:
	BANKSEL PMD0			;Bank 15
	MOVLF c_PMD0,PMD0		;Peripherals enable/disable
	MOVLF c_PMD1,PMD1		;
	MOVLF c_PMD2,PMD2		;
	MOVLF c_PMD3,PMD3		;
	MOVLF c_PMD4,PMD4		;
	MOVLF c_PMD5,PMD5		;
	MOVLF 0x20,FSR0H		;Load HIGH address of linear memory area
	CLRF FSR0L			;Load LOW address
SYS_IN1	CLRF INDF0			;Clear memory byte
	INCF FSR0L,f			;Increment position
	BTFSC STATUS,Z			;Check if zero reached
	INCF FSR0H,f			;YES, Increment HIGH address
        BTFSS FSR0H,c_MAXRAM		;Check if reached RAM limit
	GOTO SYS_IN1			;NO, keep going
	BANKSEL PORTA			;Bank 0
	BSF f_LCD_REFSH			;Force LCD refresh/reload
	RETURN
