;*****************************************************************************
;*                                                                           *
;* Display prototyping board basic                                           *
;* Copyright (C) 2022 by Walter Lain <kcswalter@member.fsf.org>              *
;*                                                                           *
;* This program is free software; you can redistribute it and/or modify      *
;* it under the terms of the GNU General Public License as published by      *
;* the Free Software Foundation; either version 3 of the License, or         *
;* (at your option) any later version.                                       *
;*                                                                           *
;* This program is distributed in the hope that it will be useful,           *
;* but WITHOUT ANY WARRANTY; without even the implied warranty of            *
;* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
;* GNU General Public License for more details.                              *
;*                                                                           *
;* You should have received a copy of the GNU General Public License         *
;* along with this program; if not, write to the Free Software               *
;* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
;*                                                                           *
;*****************************************************************************

; ________________________________________________
; |         Timer control for Disp-proto         |
; |______________________________________________|
; |   Src File                                   |
; |______________________________________________|
; |   Type      : ASM                            |
; |   Version   : 0                              |
; |   Release   : 1                              |
; |   Author    : Lain Walter                    |
; |   Date      : 14/03/22                       |
; |______________________________________________|

;_______________________________________________________Timer init
;Initialize timers
;Modified registers:
;	system
;	b_TMR3_CNT
;Call method
;	CALL Timer_Init
Timer_Init:
	BANKSEL T1CON			;Bank 4
	BCF T1CON,TMR1ON		;Disable Timer1
	MOVLF c_TMR1_CON,T1CON		;Set Timer1
	MOVLF c_TMR1_GCON,T1GCON	;
	MOVLF c_TMR1_GATE,T1GATE	;
	MOVLF c_TMR1_CLK,T1CLK		;
	MOVLF c_TMR1_TIME_H,TMR1H	;Set timer1 duration
	MOVFF c_TMR1_TIME_L,TMR1L	;
	BANKSEL PIR0			;Bank 14
	BCF PIR4,TMR1IF			;Clear Timer1 IRQ flag
	BSF PIE4,TMR1IE			;Enable Timer1 IRQ
	BANKSEL WDTCON0			;Bank 16
	MOVLF c_WDT_SET1,WDTCON0	;Set Watchdog, keep it disabled
	MOVLF c_WDT_SET2,WDTCON1	;Set Watchdog
	BANKSEL OSCTUNE			;Bank 17
	MOVLF c_OSCTUNE,OSCTUNE		;Trim internal oscillator
	BANKSEL b_TMR7_CNT		;Bank 0
	MOVLF c_TMR7_DIV,b_TMR7_CNT	;Load Timer7
	RETURN

	
;_______________________________________________________Display clock delays
;Routines for display clock delay
;What follows is not nicely done, but since it's only done once at system
; init, I don't want to set a timer for it. Timings are calculated for a
; 32MHz system clock. Also, using only shared memory registers, I don't need to
; swap banks.
;Modified registers
;	System
;	R0H
;	R0L
;	R1H
;Call method
;	CALL Disp_Ck...
Disp_Ck100ms:				;[2]
	MOVLF .10,R0H			;[2]
D_CK03	MOVLF .99,R0L			;[2] L3=(L2+5)*9+(L2+4)=799959 (100ms)
D_CK02	MOVLF .201,R1H			;[2] L2=(L1+5)*98+(L1+4)=79991 (10ms)
D_CK01	NOP				;[1] L1=4*200+3=803 (100.4us)
	DECFSZ R1H,f			;[1/2]
	GOTO D_CK01			;[2]
	DECFSZ R0L,f			;[1/2]
	GOTO D_CK02			;[2]
	DECFSZ R0H,f			;[1/2]
	GOTO D_CK03			;[2]
	RETURN				;[2] -> 100ms total

Disp_Ck2ms:				;[2]
	MOVLF .20,R0L			;[2]
D_CK05	MOVLF .200,R0H			;[2] L2=(L1+5)*19+(L1+4)=16079 (2.01ms)
D_CK04	NOP				;[1] L1=4*199+3=799 (99.9us)
	DECFSZ R0H,f			;[1/2]
	GOTO D_CK04			;[2]
	DECFSZ R0L,f			;[1/2]
	GOTO D_CK05			;[2]
	RETURN				;[2] -> 2.01ms total

Disp_Ck100us:				;[2]
	MOVLF .199,R0H			;[2]
D_CK06	NOP				;[1] L1=4*199+3=795 (99.4us)
	DECFSZ R0H,f			;[1/2]
	GOTO D_CK06			;[2]
	RETURN				;[2] -> 100.1us total

Disp_Ck38us:				;[2]
	MOVLF .76,R0H			;[2]
D_CK07	NOP				;[1] L1=4*74+3=299 (37.4us)
	DECFSZ R0H,f			;[1/2]
	GOTO D_CK07			;[2]
	RETURN				;[2] -> 38.1us total

Disp_Ck625ns:				;[2]
	NOP				;[1]
	RETURN				;[2] -> 625ns total
