;*****************************************************************************
;*                                                                           *
;* Display prototyping board basic                                           *
;* Copyright (C) 2022 by Walter Lain <kcswalter@member.fsf.org>              *
;*                                                                           *
;* This program is free software; you can redistribute it and/or modify      *
;* it under the terms of the GNU General Public License as published by      *
;* the Free Software Foundation; either version 3 of the License, or         *
;* (at your option) any later version.                                       *
;*                                                                           *
;* This program is distributed in the hope that it will be useful,           *
;* but WITHOUT ANY WARRANTY; without even the implied warranty of            *
;* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
;* GNU General Public License for more details.                              *
;*                                                                           *
;* You should have received a copy of the GNU General Public License         *
;* along with this program; if not, write to the Free Software               *
;* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
;*                                                                           *
;*****************************************************************************

; ________________________________________________
; |    Include for Disp-proto Analog control     |
; |______________________________________________|
; |   Include File                               |
; |______________________________________________|
; |   Type      : INC                            |
; |   Version   : 0                              |
; |   Release   : 1                              |
; |   Author    : Lain Walter                    |
; |   Date      : 14/03/22                       |
; |______________________________________________|

;_______________________________________________________Constants
c_ADCON0	EQU	B'11000100'	;Enable ADC, continuous operation, Fosc-->Clock,
					; right justify, start ADC
c_ADCON1	EQU	B'00000000'	;Precharge to VDD always, guard ring low,
					; one conversion per trigger
c_ADCON2	EQU	B'11011100'	;Transfer ADFLTR, Low-pass 2^5, start initial clear
c_ADCON3	EQU	B'00000000'	;ADGO managed by software, ADTIF disabled
c_ADCLK		EQU	B'00111111'	;ADC clock FOSC/128
c_ADREF		EQU	B'00000000'	;Vref-=AVss, Vref+=Vdd
c_ADPCH		EQU	B'00001101'	;Select channel ANB5 (Push)
c_ANA_AVG_SMP	EQU	.16		;Analog average samples
C_ANA_AVG_BIT	EQU	.4		;Analog average samples (bit check)

;_______________________________________________________Variables
	BYTE b_ANA_PUSH			;Analog push read
	BYTE b_ANA_STAT			;Analog status
	BYTE b_ANA_ACNT			;Analog average counter

;_______________________________________________________Flags
#define f_ANA_FIRST	b_ANA_STAT,0	;First analog read flag (used to throw away the
					; first reading, as it will be crap
