;*****************************************************************************
;*                                                                           *
;* Display prototyping board basic                                           *
;* Copyright (C) 2022 by Walter Lain <kcswalter@member.fsf.org>              *
;*                                                                           *
;* This program is free software; you can redistribute it and/or modify      *
;* it under the terms of the GNU General Public License as published by      *
;* the Free Software Foundation; either version 3 of the License, or         *
;* (at your option) any later version.                                       *
;*                                                                           *
;* This program is distributed in the hope that it will be useful,           *
;* but WITHOUT ANY WARRANTY; without even the implied warranty of            *
;* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
;* GNU General Public License for more details.                              *
;*                                                                           *
;* You should have received a copy of the GNU General Public License         *
;* along with this program; if not, write to the Free Software               *
;* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
;*                                                                           *
;*****************************************************************************

; ________________________________________________
; |    Include for Disp-proto Display control    |
; |______________________________________________|
; |   Include File                               |
; |______________________________________________|
; |   Type      : INC                            |
; |   Version   : 0                              |
; |   Release   : 1                              |
; |   Author    : Lain Walter                    |
; |   Date      : 14/03/22                       |
; |______________________________________________|

;_______________________________________________________Constants
c_DISP_ANDMSK	EQU	B'11110000'	;Display AND mask
c_DISP_ANDMSKL	EQU	B'00001111'	;Display AND mask LSN
c_DISP_INIT1	EQU	B'00000011'	;Function set, wake-up (OR)
c_DISP_INIT2A	EQU	B'00000010'	;Function set, 4 bit mode (OR)
c_DISP_INIT2B	EQU	B'00001000'	;Function set, 2 lines, 5x8 dots font (OR)
c_DISP_CMDA	EQU	B'00000000'	;Display control, 4 bit mode (OR)
c_DISP_OFFB	EQU	B'00001000'	;Display control, display OFF (OR)
c_DISP_ONNCNBB	EQU	B'00001100'	;Display control, display ON, cursor+blink OFF (OR)
c_DISP_ONSCNBB	EQU	B'00001110'	;Display control, display ON, cursor ON, blink OFF (OR)
c_DISP_ONSCSBB	EQU	B'00001111'	;Display control, display ON, cursor ON and blinking (OR)
c_DISP_CLRB	EQU	B'00000001'	;Display clear command (OR)
c_DISP_RETB	EQU	B'00000010'	;Display return home (OR)
c_DISP_MODEB	EQU	B'00000110'	;Display mode set, cursor increment, no shift (OR)

c_ROW1_ADDR	EQU	0x00		;Display row1 start address
c_ROW2_ADDR	EQU	0x40		;Display row2 start address
c_P1ST_ADDR	EQU	0x43		;Display P1 status address
c_P2ST_ADDR	EQU	0x47		;Display P2 status address
c_P3ST_ADDR	EQU	0x4B		;Display P3 status address
c_P4ST_ADDR	EQU	0x4F		;Display P4 status address

;_______________LCD characters definition (ST7066U-0A)
c_CHAR_LCD_SPC	EQU	0x20		;space
c_CHAR_LCD_EXCL	EQU	0x21		;!
c_CHAR_LCD_QUOT	EQU	0x22		;"
c_CHAR_LCD_SHRP	EQU	0x23		;#
c_CHAR_LCD_DOLR	EQU	0x24		;$
c_CHAR_LCD_PERC	EQU	0x25		;%
c_CHAR_LCD_AMPR	EQU	0x26		;&
c_CHAR_LCD_APIC	EQU	0x27		;'
c_CHAR_LCD_PARA	EQU	0x28		;(
c_CHAR_LCD_PARC	EQU	0x29		;)
c_CHAR_LCD_ASTR	EQU	0x2A		;*
c_CHAR_LCD_PLUS	EQU	0x2B		;+
c_CHAR_LCD_CMMA	EQU	0x2C		;,
c_CHAR_LCD_MINU	EQU	0x2D		;-
c_CHAR_LCD_DOT	EQU	0x2E		;.
c_CHAR_LCD_SLSH	EQU	0x2F		;/
c_CHAR_LCD_COLN	EQU	0x3A		;:
c_CHAR_LCD_SMCL	EQU	0x3B		;;
c_CHAR_LCD_MINR	EQU	0x3C		;<
c_CHAR_LCD_EQUL	EQU	0x3D		;=
c_CHAR_LCD_MAGR	EQU	0x3E		;>
c_CHAR_LCD_QSTM	EQU	0x3F		;?
c_CHAR_LCD_MAIL	EQU	0x40		;@
c_CHAR_LCD_SQRO	EQU	0x5B		;[
c_CHAR_LCD_YEN	EQU	0x5C		;yen(?) symbol
c_CHAR_LCD_SQRC	EQU	0x5D		;]
c_CHAR_LCD_ACRN	EQU	0x5E		;^
c_CHAR_LCD_UNDR	EQU	0x5F		;_
c_CHAR_LCD_LPIC	EQU	0x60		;`
c_CHAR_LCD_GRFO	EQU	0x7B		;{
c_CHAR_LCD_PIPE	EQU	0x7C		;|
c_CHAR_LCD_GRFC	EQU	0x7D		;}
c_CHAR_LCD_ARRR	EQU	0x7E		;right arrow
c_CHAR_LCD_ARRL	EQU	0x7F		;left arrow
c_CHAR_LCD_DEGR	EQU	0xDF		;
c_CHAR_LCD_DIVI	EQU	0xFD		;divide
c_CHAR_LCD_BLCK	EQU	0xFF		;black rectangle

c_CHAR_LCD_0	EQU	0x30
c_CHAR_LCD_1	EQU	0x31
c_CHAR_LCD_2	EQU	0x32
c_CHAR_LCD_3	EQU	0x33
c_CHAR_LCD_4	EQU	0x34
c_CHAR_LCD_5	EQU	0x35
c_CHAR_LCD_6	EQU	0x36
c_CHAR_LCD_7	EQU	0x37
c_CHAR_LCD_8	EQU	0x38
c_CHAR_LCD_9	EQU	0x39

c_CHAR_LCD_A	EQU	0x41
c_CHAR_LCD_B	EQU	0x42
c_CHAR_LCD_C	EQU	0x43
c_CHAR_LCD_D	EQU	0x44
c_CHAR_LCD_E	EQU	0x45
c_CHAR_LCD_F	EQU	0x46
c_CHAR_LCD_G	EQU	0x47
c_CHAR_LCD_H	EQU	0x48
c_CHAR_LCD_I	EQU	0x49
c_CHAR_LCD_J	EQU	0x4A
c_CHAR_LCD_K	EQU	0x4B
c_CHAR_LCD_L	EQU	0x4C
c_CHAR_LCD_M	EQU	0x4D
c_CHAR_LCD_N	EQU	0x4E
c_CHAR_LCD_O	EQU	0x4F
c_CHAR_LCD_P	EQU	0x50
c_CHAR_LCD_Q	EQU	0x51
c_CHAR_LCD_R	EQU	0x52
c_CHAR_LCD_S	EQU	0x53
c_CHAR_LCD_T	EQU	0x54
c_CHAR_LCD_U	EQU	0x55
c_CHAR_LCD_V	EQU	0x56
c_CHAR_LCD_W	EQU	0x57
c_CHAR_LCD_X	EQU	0x58
c_CHAR_LCD_Y	EQU	0x59
c_CHAR_LCD_Z	EQU	0x5A

c_CHAR_LCD_a	EQU	0x61
c_CHAR_LCD_b	EQU	0x62
c_CHAR_LCD_c	EQU	0x63
c_CHAR_LCD_d	EQU	0x64
c_CHAR_LCD_e	EQU	0x65
c_CHAR_LCD_f	EQU	0x66
c_CHAR_LCD_g	EQU	0x67
c_CHAR_LCD_h	EQU	0x68
c_CHAR_LCD_i	EQU	0x69
c_CHAR_LCD_j	EQU	0x6A
c_CHAR_LCD_k	EQU	0x6B
c_CHAR_LCD_l	EQU	0x6C
c_CHAR_LCD_m	EQU	0x6D
c_CHAR_LCD_n	EQU	0x6E
c_CHAR_LCD_o	EQU	0x6F
c_CHAR_LCD_p	EQU	0x70
c_CHAR_LCD_q	EQU	0x71
c_CHAR_LCD_r	EQU	0x72
c_CHAR_LCD_s	EQU	0x73
c_CHAR_LCD_t	EQU	0x74
c_CHAR_LCD_u	EQU	0x75
c_CHAR_LCD_v	EQU	0x76
c_CHAR_LCD_w	EQU	0x77
c_CHAR_LCD_x	EQU	0x78
c_CHAR_LCD_y	EQU	0x79
c_CHAR_LCD_z	EQU	0x7A

;_______________________________________________________Variables
	BYTE b_BCD_HNDT			;BCD Hundreds
	BYTE b_BCD_TENT			;BCD Tens
	BYTE b_BCD_UNIT			;BCD Units

;_______________________________________________________Flags
