;*****************************************************************************
;*                                                                           *
;* Display prototyping board basic                                           *
;* Copyright (C) 2022 by Walter Lain <kcswalter@member.fsf.org>              *
;*                                                                           *
;* This program is free software; you can redistribute it and/or modify      *
;* it under the terms of the GNU General Public License as published by      *
;* the Free Software Foundation; either version 3 of the License, or         *
;* (at your option) any later version.                                       *
;*                                                                           *
;* This program is distributed in the hope that it will be useful,           *
;* but WITHOUT ANY WARRANTY; without even the implied warranty of            *
;* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
;* GNU General Public License for more details.                              *
;*                                                                           *
;* You should have received a copy of the GNU General Public License         *
;* along with this program; if not, write to the Free Software               *
;* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
;*                                                                           *
;*****************************************************************************

; ________________________________________________
; |      Include for Disp-proto I/O control      |
; |______________________________________________|
; |   Include File                               |
; |______________________________________________|
; |   Type      : INC                            |
; |   Version   : 0                              |
; |   Release   : 1                              |
; |   Author    : Lain Walter                    |
; |   Date      : 14/03/22                       |
; |______________________________________________|

;_______________________________________________________Constants
c_TRISA		EQU	B'11111111'	;PortA I/O config (all pins as inputs)
c_ANSA		EQU	B'00000000'	;PortA D/A config (all pins digital I/O)
c_WPUA		EQU	B'11111111'	;PortA Pull-Ups config (all enabled)
c_ODCA		EQU	B'00000000'	;PortA Open-Drain config (all pins standard push-pull)
c_SLRA		EQU	B'00000000'	;PortA Slew Rate config (all pins on max slew rate)
c_INLVA		EQU	B'00000000'	;PortA Input level config (all pins on TTL levels)

c_TRISB		EQU	B'11101111'	;PortB I/O config (all pins as inputs except RB4)
c_ANSB		EQU	B'00100000'	;PortB D/A config (all pins digital I/O except RB5)
c_WPUB		EQU	B'00000000'	;PortB Pull-Ups config (all disabled)
c_ODCB		EQU	B'00000000'	;PortB Open-Drain config (all pins standard push-pull)
c_SLRB		EQU	B'00000000'	;PortB Slew Rate config (all pins on max slew rate)
c_INLVB		EQU	B'00000000'	;PortB Input level config (all pins on TTL levels)

c_TRISC		EQU	B'10011111'	;PortC I/O config (all pins as inputs except RC5 and RC6)
c_ANSC		EQU	B'00000000'	;PortC D/A config (all pins digital I/O)
c_WPUC		EQU	B'11111111'	;PortC Pull-Ups config (all enabled)
c_ODCC		EQU	B'00000000'	;PortC Open-Drain config (all pins standard push-pull)
c_SLRC		EQU	B'00000000'	;PortC Slew Rate config (all pins on max slew rate)
c_INLVC		EQU	B'00000000'	;PortC Input level config (all pins on TTL levels)

c_TRISD		EQU	B'11111111'	;PortD I/O config (all pins as inputs)
c_ANSD		EQU	B'00000000'	;PortD D/A config (all pins digital I/O)
c_WPUD		EQU	B'11111111'	;PortD Pull-Ups config (all enabled)
c_ODCD		EQU	B'00000000'	;PortD Open-Drain config (all pins standard push-pull)
c_SLRD		EQU	B'00000000'	;PortD Slew Rate config (all pins on max slew rate)
c_INLVD		EQU	B'00000000'	;PortD Input level config (all pins on TTL levels)

c_TRISE		EQU	B'00001000'	;PortD I/O config (RE0-2 as outputs, RE3-MCLR as input)
c_ANSE		EQU	B'00000000'	;PortD D/A config (all pins digital I/O)
c_WPUE		EQU	B'00001000'	;PortD Pull-Ups config (enabled only on MCLR)
c_ODCE		EQU	B'00000000'	;PortD Open-Drain config (all pins standard push-pull)
c_SLRE		EQU	B'00000000'	;PortD Slew Rate config (all pins on max slew rate)
c_INLVE		EQU	B'00000000'	;PortD Input level config (all pins on TTL levels)

c_LCD_D_PORT	EQU	PORTB		;LCD Data port
c_LCD_D_LATC	EQU	LATB		;LCD data latch
c_LCD_D_TRIS	EQU	TRISB		;LCD Data tris
c_LCDTRIS_DO	EQU	B'11110000'	;TRIS Data Output value for AND mask
c_LCDTRIS_DI	EQU	B'00001111'	;TRIS Data Input value for OR mask

c_LCD_EN_PORT	EQU	PORTE		;LCD EN port
c_LCD_EN_PIN	EQU	2		;LCD EN pin

c_LCD_RW_PORT	EQU	PORTE		;LCD R/W port
c_LCD_RW_PIN	EQU	1		;LCD R/W pin

c_LCD_RS_PORT	EQU	PORTE		;LCD RS port
c_LCD_RS_PIN	EQU	0		;LCD RS pin

c_LCD_BL_PORT	EQU	PORTB		;LCD Backlight port
c_LCD_BL_PIN	EQU	4		;LCD Backlight pin

c_PUSH_HIF	EQU	.4		;fast push is after 4 cycles
c_PUSH_HIR	EQU	6		;first repeat occurs after 64+HIF cycles
c_PUSH_RPT	EQU	5		;subsequent after 32+HIF cycles
c_PUSH_RES	EQU	b'11110000'	;Reset pushbuttons 1-4

c_PUSH1_LO	EQU	.42		;Pushbutton 1 low level -1
c_PUSH1_HI	EQU	.49		;Pushbutton 1 high level
c_PUSH2_LO	EQU	.87		;Pushbutton 2 low level -1
c_PUSH2_HI	EQU	.94		;Pushbutton 2 high level
c_PUSH3_LO	EQU	.124		;Pushbutton 3 low level -1
c_PUSH3_HI	EQU	.131		;Pushbutton 3 high level
c_PUSH4_LO	EQU	.167		;Pushbutton 4 low level -1
c_PUSH4_HI	EQU	.174		;Pushbutton 4 high level

;_______________________________________________________Variables
	BYTE b_PUSH1_CNT		;Pushbutton 1 (+) press counter
	BYTE b_PUSH2_CNT		;Pushbutton 2 (-) press counter
	BYTE b_PUSH3_CNT		;Pushbutton 3 (OK) press counter
	BYTE b_PUSH4_CNT		;Pushbutton 4 (ESC) press counter
	BYTE b_SW_STAT			;Pushbutton status

;_______________________________________________________Flags
#define f_PUSH1_HI	b_SW_STAT,0	;Push 1 high state
#define f_PUSH2_HI	b_SW_STAT,1	;Push 2 high state
#define f_PUSH3_HI	b_SW_STAT,2	;Push 3 high state
#define f_PUSH4_HI	b_SW_STAT,3	;Push 4 high state
#define f_PUSH_RPT	b_SW_STAT,4	;Push repeat state
