;*****************************************************************************
;*                                                                           *
;* Display prototyping board basic                                           *
;* Copyright (C) 2022 by Walter Lain <kcswalter@member.fsf.org>              *
;*                                                                           *
;* This program is free software; you can redistribute it and/or modify      *
;* it under the terms of the GNU General Public License as published by      *
;* the Free Software Foundation; either version 3 of the License, or         *
;* (at your option) any later version.                                       *
;*                                                                           *
;* This program is distributed in the hope that it will be useful,           *
;* but WITHOUT ANY WARRANTY; without even the implied warranty of            *
;* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
;* GNU General Public License for more details.                              *
;*                                                                           *
;* You should have received a copy of the GNU General Public License         *
;* along with this program; if not, write to the Free Software               *
;* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
;*                                                                           *
;*****************************************************************************

; ________________________________________________
; |     Include for Temp ctrl timer control      |
; |______________________________________________|
; |   Include File                               |
; |______________________________________________|
; |   Type      : INC                            |
; |   Version   : 0                              |
; |   Release   : 1                              |
; |   Author    : Lain Walter                    |
; |   Date      : 14/03/22                       |
; |______________________________________________|

;_______________________________________________________Constants
c_TMR1_CON	EQU	B'00010000'	;Timer1 on internal CLK with 1:2 prescaler
c_TMR1_GCON	EQU	B'00000000'	;Timer1 gate control disable (always counting)
c_TMR1_CLK	EQU	B'00000001'	;Timer1 clock to Fosc/4
c_TMR1_GATE	EQU	B'00000000'	;Timer1 gate select (unused, gate disabled)

c_WDT_SET1	EQU	B'00000000'	;Watchdog set 1 (Prescaler 1:32, Watchdog disabled)
c_WDT_SET2	EQU	B'00000111'	;Watchdog set 2 (Timer LFINTOSC, Window 0-100%)

c_OSCTUNE	EQU	0x20		;Oscillator trim value
					; 0x00 -> 0x1F = increase freq.
					; 0x3F -> 0x20 = decrease freq.

;_______________________Main Timer
;System main timer (0x9C40 = 5 ms with CLK @ 32MHz)
; Since the timer increments up to FFFF and then goes into IRQ, I must subtract
; the needed value from FFFF and use the result
c_TMR1_TIME_H   EQU	0x63            ;Main timer value
c_TMR1_TIME_L   EQU	0xBF            ;

;_______________________Dividers
c_TMR7_DIV      EQU	.10		;slow cycle 1 delay (100ms)

c_DISP_TOUT	EQU	.80		;Timer for 200us of busy flag waiting (for Disp_WaitBF sub)

;_______________________________________________________Variabili
	BYTE b_TMR7_CNT			;Slow cycle 1 counter
	BYTE b_TMR_STAT			;Timers status

;_______________________________________________________Flags
#define f_IRQ_TIMER1_ON b_TMR_STAT,0	;Timer1 IRQ flag
#define f_CK1_DIV	b_TMR_STAT,1	;Fast loop divider counter
;I borrow 1 bit for display management to avoid using another byte of RAM
#define f_LCD_REFSH	b_TMR_STAT,7	;Force display refresh
